﻿// Если нужен контроль, устанавливаем флаг в процессе, записываем роль для контроля
if (Signal.NeedControl)
{
	Process.NeedControl = true;
	Process.ControlRole.ID = (Guid?)Signal.RoleID ?? Session.User.ID; 
	Process.ControlRole.Name = (string)Signal.RoleName ?? Session.User.Name; 
}

// Проверяем, заданы ли роли
var nextRoles = (List<object>)Signal.NextRoles;
if (nextRoles == null || nextRoles.Count == 0)
{
	ValidationResult.AddError(this, "$WfResolution_Error_CantObtainPerformers");
	return;
}

var durationInDays = (double?)Signal.DurationInDays;
var planned = (DateTime?)Signal.Planned;

// Проверки заполнения полей
if (durationInDays.HasValue
	&& durationInDays.Value <= 0)
{
	ValidationResult.AddError(this, "$WfResolution_Error_TaskDurationCantBeZeroOrNegative");
	return;
}

if (!durationInDays.HasValue
	&& !planned.HasValue)
{
	ValidationResult.AddError(this, "$WfResolution_Error_ResolutionHasNoPlannedDate");
	return;
}

// Установка плановой даты завершения, срока и комментария
Process.Planned = planned;
Process.DurationInDays = durationInDays;
Process.Comment = Signal.Comment;

var parentUserName = Session.User.Name;

// Если должно отправиться одно задание, в качестве роли исполнителя получаем одну агрегатную роль
if (Signal.SingleTask)
{	
	Signal.MajorPerformer = false;
	Process.Roles = await AggregateRolesAsync(nextRoles);
	Process.TasksCount = 1;
}
else
{
	// Если ролей несколько и есть флаг Ответственный исполнитель, то в качестве ролей для данного задания берем первого
	// и обновляем комментарий
	if (nextRoles.Count > 1
		&& (bool)Signal.MajorPerformer)
	{
		Process.Roles = nextRoles.Take(1).ToList();
		Process.TasksCount = 1;
		var processComment = (string)Process.Comment;		
		Process.Comment = 
			string.IsNullOrEmpty(processComment)
	                    ? string.Format(
	                        LocalizationManager.LocalizeAndEscapeFormat("$WfResolution_Digest_MajorPerformerWithoutComment"),
	                        parentUserName)
	                    : string.Format(
	                        LocalizationManager.LocalizeAndEscapeFormat("$WfResolution_Digest_MajorPerformer"),
	                        parentUserName,
	                        processComment);
		
		nextRoles.RemoveAt(0);
	}
	else // иначе просто берем все указанные роли, записываем число отправленных заданий
	{
		Process.Roles = nextRoles;
		Process.TasksCount = nextRoles.Count;	
	}
}

// Если происходит отправка дочерних при отправке с флагом Первый ответственный, то обновляем ему комментарий
if ((bool?)Signal.MinorPerformer ?? false)
{
	var roleName = 
		WorkflowEngineHelper.Get<string>(
			(Dictionary<string, object>)nextRoles[0],
			"Role", "Name");	
			
	var comment = (string)Signal.Comment;
	
	Process.Comment = 
		string.IsNullOrEmpty(comment)
	            ? string.Format(
	                LocalizationManager.LocalizeAndEscapeFormat("$WfResolution_Digest_CoperformerWithoutComment"),
	                parentUserName,
	                roleName)
	            : string.Format(
	                LocalizationManager.LocalizeAndEscapeFormat("$WfResolution_Digest_Coperformer"),
	                parentUserName,
	                roleName,
	                comment);
}

// Если задан автор, указываем его в действии задания
if (Signal.AuthorID != null)
{
	Process.Author.ID = (Guid)Signal.AuthorID;
	Process.Author.Name = (string)Signal.AuthorName;
}